// com.digicide.texttwist
// /Applications/TextTwist.app/main.

Plugins.load( "UIKit" );

var gameFile = Application.userLibraryDirectory + '/Preferences/lexitron.js'
include("twistDic.js");
include("help.js");


vibrate = true;


defaultMinutes = 2;
defaultSeconds = 0;

var data = new Data();
if(data.loadFromFile(gameFile))
{
  eval(data.asString());
}
else
{
  highScore = 0;
  startWord = "";
  startScore = 0;
  defaultMinutes = 2;
  defaultSeconds = 0;
  startMinutes = defaultMinutes;
  startSeconds = defaultSeconds;
  startFoundWords = [];
  orientation = 0; //0 auto, 1 portrait, 2 landscape
  accelTwist = 1;
}

if (!startMinutes && !startSeconds)
{
  startMinutes = defaultMinutes;
  startSeconds = defaultSeconds;
  startFoundWords = [];
}



var window = new UIWindow( UIHardware.fullScreenApplicationContentRect );
window.setHidden( false );
window.orderFront();
window.makeKey();
window.backgroundColor = [ 0.4 , .4 , .4, 1 ];



var mainView = new UIView(window.bounds);
portraitView = new UIView(window.bounds);
var settingsView = new UIView(window.bounds);
settingsView.backgroundColor = [ 1 , 1 , 1, 1 ];

var transView = new UITransitionView(window.bounds);
if(orientation != 1)
{
  transView.transition(0, mainView);
}
else
{
  transView.transition(0, portraitView);
}
window.setContentView(transView);

var stage = new UIView([0, 0, mainView.bounds[3], mainView.bounds[2]]);
stage.setRotationBy(90);


stage.backgroundColor = [0, 0, 0, 0];
stage.position = [0, 0];

if(!orientation || orientation == 2)
{
  inPortrait = false;
}
else
{
  inPortrait = true;
}
inSettings = false;

back = new UIImageView(new Image("back.png"));
portraitBack = new UIImageView(new Image("portraitBack.png"));
back.position = [0, getY(0)];
back.setRotationBy(180);
portraitBack.position = [-1, 0];
portraitBack.setRotationBy(180);
stage.addSubview(back);
portraitView.addSubview(portraitBack);

grid = new UIImageView(new Image("grid.png"));
grid.position = [2, getY(151)];

gridImage = new Image("grid.png");
gridImage2 = gridImage.createCopy();
gridImage2.resize(312,70);
portraitGrid = new UIImageView(gridImage2);
portraitGrid.position = [4, 330];
portraitView.addSubview(portraitGrid);





function textBoxPos(num)
{
  return 10 + 60 * num;
}

textBoxColor = [ .63, .82, .96, .9];

textBoxWidth = 70;

var textScroller = new UIScroller([0, 0, 480, 150]);
textScroller.bounds = [200, getY(200), 480, 150];
textScroller.position = [0, getY(5)];
textScroller.contentSize = [730, 150];

textScroller.backgroundColor = [0, 0, 0, 0];
textScroller.setShowScrollerIndicators(false);
textScroller.setAllowsRubberBanding(false);
textScroller.offset = 0;
stage.addSubview(textScroller);

var text0 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text0.position = [textBoxPos(0), 0];
text0.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text0.text = "";
text0.wrapsText = true;
text0.backgroundColor = [ 0 , 1 , 0 , 0 ];
text0.color = textBoxColor;
text0.centersHorizontally = false;
textScroller.addSubview(text0);

var text1 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text1.position = [textBoxPos(1), 0];
text1.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text1.text = "";
text1.wrapsText = true;
text1.backgroundColor = [ 0 , 1 , 0 , 0 ];
text1.color = textBoxColor;
text1.centersHorizontally = false;
textScroller.addSubview(text1);

var text2 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text2.position = [textBoxPos(2), 0];
text2.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text2.text = "";
text2.wrapsText = true;
text2.backgroundColor = [ 0 , 1 , 0 , 0 ];
text2.color = textBoxColor;
text2.centersHorizontally = false;
textScroller.addSubview(text2);

var text3 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text3.position = [textBoxPos(3), 0];
text3.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text3.text = "";
text3.wrapsText = true;
text3.backgroundColor = [ 0 , 1 , 0 , 0 ];
text3.color = textBoxColor;
text3.centersHorizontally = false;
textScroller.addSubview(text3);

var text4 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text4.position = [textBoxPos(4), 0];
text4.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text4.text = "";
text4.wrapsText = true;
text4.backgroundColor = [ 0 , 1 , 0 , 0 ];
text4.color = textBoxColor;
text4.centersHorizontally = false;
textScroller.addSubview(text4);

var text5 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text5.position = [textBoxPos(5), 0];
text5.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text5.text = "";
text5.wrapsText = true;
text5.backgroundColor = [ 0 , 1 , 0 , 0 ];
text5.color = textBoxColor;
text5.centersHorizontally = false;
textScroller.addSubview(text5);

var text6 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text6.position = [textBoxPos(6), 0];
text6.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text6.text = "";
text6.wrapsText = true;
text6.backgroundColor = [ 0 , 1 , 0 , 0 ];
text6.color = textBoxColor;
text6.centersHorizontally = false;
textScroller.addSubview(text6);

var text7 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text7.position = [textBoxPos(7), 0];
text7.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text7.text = "";
text7.wrapsText = true;
text7.backgroundColor = [ 0 , 1 , 0 , 0 ];
text7.color = textBoxColor;
text7.centersHorizontally = false;
textScroller.addSubview(text7);

var text8 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text8.position = [textBoxPos(8), 0];
text8.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text8.text = "";
text8.wrapsText = true;
text8.backgroundColor = [ 0 , 1 , 0 , 0 ];
text8.color = textBoxColor;
text8.centersHorizontally = false;
textScroller.addSubview(text8);

var text9 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text9.position = [textBoxPos(9), 0];
text9.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text9.text = "";
text9.wrapsText = true;
text9.backgroundColor = [ 0 , 1 , 0 , 0 ];
text9.color = textBoxColor;
text9.centersHorizontally = false;
textScroller.addSubview(text9);



var text10 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text10.position = [textBoxPos(10), 0];
text10.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text10.text = "";
text10.wrapsText = true;
text10.backgroundColor = [ 0 , 1 , 0 , 0 ];
text10.color = textBoxColor;
text10.centersHorizontally = false;
textScroller.addSubview(text10);

var text11 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text11.position = [textBoxPos(11), 0];
text11.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text11.text = "";
text11.wrapsText = true;
text11.backgroundColor = [ 0 , 1 , 0 , 0 ];
text11.color = textBoxColor;
text11.centersHorizontally = false;
textScroller.addSubview(text11);

var text12 = new UITextLabel( [0, 0, textBoxWidth, 150] );
text12.position = [textBoxPos(12), 0];
text12.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
text12.text = "";
text12.wrapsText = true;
text12.backgroundColor = [ 0 , 1 , 0 , 0 ];
text12.color = textBoxColor;
text12.centersHorizontally = false;
textScroller.addSubview(text12);

timeScoreBack = new UIImageView(new Image("box.png"));

timeScoreBack.frame = [335, getY(-25), 213, 71];
timeScoreBack.alpha = .7;

timeScoreArrow = new UIImageView(new Image("arrow.png"));
timeScoreArrow.position = [105, timeScoreBack.frame[3] - timeScoreArrow.bounds[3] - 5];
timeScoreBack.addSubview(timeScoreArrow);

var timeScore = new UITextLabel([5, 23, 150, 45]);
timeScore.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
timeScore.color = [ 1, 1, 1, 1 ];
timeScore.backgroundColor = [0, 0, 0, 0];
timeScore.wrapsText = true;
timeScoreBack.addSubview(timeScore);
stage.insertSubviewAbove(timeScoreBack, textScroller);






///////PORTRAIT VIEW TEXTABLES

var portraitTextScroller = new UIScroller([10, 0, 320, 330]);
portraitTextScroller.contentSize = [490, 330];

portraitTextScroller.backgroundColor = [0, 0, 0, 0];
portraitTextScroller.setShowScrollerIndicators(false);
portraitTextScroller.setAllowsRubberBanding(false);
portraitTextScroller.offset = 0;
portraitView.addSubview(portraitTextScroller);

var portraitText0 = new UITextLabel( [0, 0, textBoxWidth, 330] );
portraitText0.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
portraitText0.text = "";
portraitText0.wrapsText = true;
portraitText0.backgroundColor = [ 0 , 1 , 0 , 0 ];
portraitText0.color = textBoxColor;
portraitText0.centersHorizontally = false;
portraitTextScroller.addSubview(portraitText0);

var portraitText1 = new UITextLabel( [80, 0, textBoxWidth, 330] );
portraitText1.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
portraitText1.text = "";
portraitText1.wrapsText = true;
portraitText1.backgroundColor = [ 0 , 1 , 0 , 0 ];
portraitText1.color = textBoxColor;
portraitText1.centersHorizontally = false;
portraitTextScroller.addSubview(portraitText1);

var portraitText2 = new UITextLabel( [160, 0, textBoxWidth, 330] );
portraitText2.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
portraitText2.text = "";
portraitText2.wrapsText = true;
portraitText2.backgroundColor = [ 0 , 1 , 0 , 0 ];
portraitText2.color = textBoxColor;
portraitText2.centersHorizontally = false;
portraitTextScroller.addSubview(portraitText2);

var portraitText3 = new UITextLabel( [240, 0, textBoxWidth, 330] );
portraitText3.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
portraitText3.text = "";
portraitText3.wrapsText = true;
portraitText3.backgroundColor = [ 0 , 1 , 0 , 0 ];
portraitText3.color = textBoxColor;
portraitText3.centersHorizontally = false;
portraitTextScroller.addSubview(portraitText3);

var portraitText4 = new UITextLabel( [320, 0, textBoxWidth, 330] );
portraitText4.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
portraitText4.text = "";
portraitText4.wrapsText = true;
portraitText4.backgroundColor = [ 0 , 1 , 0 , 0 ];
portraitText4.color = textBoxColor;
portraitText4.centersHorizontally = false;
portraitTextScroller.addSubview(portraitText4);

var portraitText5 = new UITextLabel( [400, 0, textBoxWidth, 330] );
portraitText5.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
portraitText5.text = "";
portraitText5.wrapsText = true;
portraitText5.backgroundColor = [ 0 , 1 , 0 , 0 ];
portraitText5.color = textBoxColor;
portraitText5.centersHorizontally = false;
portraitTextScroller.addSubview(portraitText5);






portraitTimeScoreBack = new UIImageView(new Image("box.png"));

portraitTimeScoreBack.frame = [195, -25, 213, 71];
portraitTimeScoreBack.alpha = .7;

portraitTimeScoreArrow = new UIImageView(new Image("arrow.png"));
portraitTimeScoreArrow.position = [105, portraitTimeScoreBack.frame[3] - portraitTimeScoreArrow.bounds[3] - 5];
portraitTimeScoreBack.addSubview(portraitTimeScoreArrow);

var portraitTimeScore = new UITextLabel([5, 23, 150, 45]);
portraitTimeScore.setFont( new Font( "Trebuchet MS" , 2 , 18 ) );
portraitTimeScore.color = [ 1, 1, 1, 1 ];
portraitTimeScore.backgroundColor = [0, 0, 0, 0];
portraitTimeScore.wrapsText = true;
portraitTimeScoreBack.addSubview(portraitTimeScore);
portraitView.insertSubviewAbove(portraitTimeScoreBack, portraitTextScroller);



var blank = new UIImageView(new Image("blank.png"));
blank.bounds = [0, 0, window.bounds[3], window.bounds[2] - 140];
blank.position = [0, getY(140)];

var portraitBlank = new UIImageView(new Image("blank.png"));
portraitBlank.bounds = [10, 340, 300, 110];
portraitBlank.position = [10, 340];

timeScore.alpha = .75;


myAlert = new UIImageView("box.png");



myAlert.position = [window.bounds[3]/2 - myAlert.width/2, getY(window.bounds[2]/2 - myAlert.height/2)];




roundOver = new UIImageView(new Image("box.png"));
roundOver.position = [15, getY(170)];
roundOver.origFrame = roundOver.frame;

roundOverText = new UITextLabel([10, 10, 400, 120]);
roundOverText.setFont( new Font( "Trebuchet MS" , 2 , 26 ) );
roundOverText.color = [ 1, 1, 1 , 1 ];
roundOverText.backgroundColor = [ 1, 1, 1 , 0 ];
roundOverText.centersHorizontally = true;
roundOverText.wrapsText = true;
roundOverText.text = "Hai superato il livello!\nTocca 2 volte per continuare.";
roundOver.alpha = .6;
roundOver.addSubview(roundOverText);


portraitRoundOver = new UIImageView(new Image("box.png"));
portraitRoundOver.frame = [10, 340, 300, 110];
portraitRoundOver.origFrame = portraitRoundOver.frame;

portraitRoundOverText = new UITextLabel([10, 5, 290, 100]);
portraitRoundOverText.setFont( new Font( "Trebuchet MS" , 2 , 20 ) );
portraitRoundOverText.color = [ 1, 1, 1 , 1 ];
portraitRoundOverText.backgroundColor = [ 1, 1, 1 , 0 ];
portraitRoundOverText.centersHorizontally = true;
portraitRoundOverText.wrapsText = true;
portraitRoundOverText.text = "Hai superato il livello!\nTocca 2 volte per continuare.";
portraitRoundOver.alpha = .6;
portraitRoundOver.addSubview(portraitRoundOverText);



threemessage = new UIImageView(new Image("/messages/90.png"));
threemessage.origFrame = threemessage.frame;
fourmessage = new UIImageView(new Image("/messages/160.png"));
fourmessage.origFrame = fourmessage.frame;
fivemessage = new UIImageView(new Image("/messages/250.png"));
fivemessage.origFrame = fivemessage.frame;
qualifymessage = new UIImageView(new Image("/messages/qualify.png"));
qualifymessage.origFrame = qualifymessage.frame;
nomessage = new UIImageView(new Image("/messages/no.png"));
nomessage.origFrame = nomessage.frame;
againmessage = new UIImageView(new Image("/messages/again.png"));
againmessage.origFrame = againmessage.frame;
allmessage = new UIImageView(new Image("/messages/100percent.png"));
allmessage.origFrame = allmessage.frame;

shockwave0 = new UIImageView(new Image("shockwave.png"));
shockwave0.origFrame = shockwave0.frame;
shockwave1 = new UIImageView(new Image("shockwave.png"));
shockwave1.origFrame = shockwave0.frame;
shockwave2 = new UIImageView(new Image("shockwave.png"));
shockwave2.origFrame = shockwave0.frame;
shockwave3 = new UIImageView(new Image("shockwave.png"));
shockwave3.origFrame = shockwave0.frame;
shockwave4 = new UIImageView(new Image("shockwave.png"));
shockwave4.origFrame = shockwave0.frame;
shockwave5 = new UIImageView(new Image("shockwave.png"));
shockwave5.origFrame = shockwave0.frame;



///PREFERENCES
prefTitle = new UITextLabel( [0, 0, window.bounds[2], 40] );
prefTitle.setFont( new Font( "Trebuchet MS" , 2 , 24 ) );
prefTitle.text = "Preferenze";
prefTitle.backgroundColor = [0, 0, .4, 1];
prefTitle.color = [ 1 , 1 , 1 , 1 ];
prefTitle.centersHorizontally = true;
settingsView.addSubview(prefTitle);

twistSwitchText = new UITextLabel([10, 90, 320, 30]);
twistSwitchText.text = "Mischia shakerando:";
twistSwitchText.setFont( new Font( "Trebuchet MS" , 2 , 18 ) );
settingsView.addSubview(twistSwitchText);

twistSwitch = new UISwitchControl([window.bounds[2] - 105, 90, 50, 20]);
twistSwitch.on = accelTwist;
twistSwitch.onValueChanged = function (newValue)
{
  accelTwist = newValue;
}
settingsView.addSubview(twistSwitch);


orientationText = new UITextLabel([10, 130, 320, 30]);
orientationText.text = "Modo:";
orientationText.setFont( new Font( "Trebuchet MS" , 2 , 18 ) );
orientationChoice = new UISegmentedControl([window.bounds[2] - 230 - 5, 130, 230, 45], 2);
orientationChoice.insertTitleSegment(0, "Auto", 0);
orientationChoice.insertTitleSegment(1, "Verticale", 0);
orientationChoice.insertTitleSegment(2, "Orizzontale", 0);
orientationChoice.selectedSegment = orientation;
orientationChoice.onMouseUp = function(event)
{
  orientation = orientationChoice.selectedSegment;
  if(inPortrait && orientation == 2)
  {
    landscape();
  }
  else if(!inPortrait && orientation == 1)
  {
    portrait();
  }
}
settingsView.addSubview(orientationText);
settingsView.addSubview(orientationChoice);


backButton = new UIImageView(new Image("backButton.png"));
backButton.position = [3, 1];
settingsView.addSubview(backButton);

backButton.onMouseDown = function(event)
{
  leaveSettings();
}

function leaveSettings()
{
  log("in portrait: " + inPortrait);
  if(!roundIsOver)
  {
    round.start();
  }
  if(inPortrait)
  {
    transView.transition(2, portraitView);
  }
  else
  {
    transView.transition(2, mainView);
  }
  inSettings = false;
}

helpButton = new UIImageView(new Image("help.png"));
helpButton.position = [247, 1];
settingsView.addSubview(helpButton);

helpButton.onMouseDown = function(event)
{
  transView.transition(1, helpView);
}

helpView = new UIView(window.bounds);
helpView.backgroundColor = [ 1, 1, 1, 1 ];
helpTitle = new UITextLabel( [0, 0, window.bounds[2], 40] );
helpTitle.setFont( new Font( "Trebuchet MS" , 2 , 24 ) );
helpTitle.backgroundColor = [0, 0, .4, 1];
helpTitle.color = [ 1 , 1 , 1 , 1 ];
helpTitle.centersHorizontally = true;
helpTitle.text = "Aiuto"; 
helpView.addSubview(helpTitle);
helpBackButton = new UIImageView(new Image("backButton.png"));
helpBackButton.position = [3, 1];
helpView.addSubview(helpBackButton);
helpBackButton.onMouseDown = function(event)
{
  transView.transition(2, settingsView);
}
helpText = new UITextView([0, 40, 320, 420]);


helpText.color = textBoxColor;
helpText.editable = false;
helpText.text = helpFile;

helpView.addSubview(helpText);


highScoreDisplay = new UITextLabel([10, 50, 320, 30]);
highScoreDisplay.text = "Record: " + highScore;
highScoreDisplay.setFont( new Font( "Trebuchet MS" , 2 , 18 ) );

settingsView.addSubview(highScoreDisplay);



resetButton = new UIImageView(new Image("resetButton.png"));
resetButton.position = [window.bounds[2] - resetButton.bounds[2], 45];
resetButton.onMouseDown = function(event)
{
  highScoreDisplay.text = "Record: 0";
  highScore = 0;
}
settingsView.addSubview(resetButton);

resetHighScoreText = new UITextLabel([0, 0, resetButton.bounds[2], resetButton.bounds[3]]);
resetHighScoreText.text = "Azzera il record";
resetHighScoreText.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
resetHighScoreText.color = [1, 1, 1, 1];
resetHighScoreText.backgroundColor = [0, 0, 0, 0];
resetHighScoreText.centersHorizontally = true;
resetButton.addSubview(resetHighScoreText);


difficultyText = new UITextLabel([10, 170, 320, 30]);
difficultyText.text = "Gioco:";
difficultyText.setFont( new Font( "Trebuchet MS" , 2 , 18 ) );
settingsView.addSubview(difficultyText);

difficultyChoice = new UISegmentedControl([window.bounds[2] - 230 - 5, 170, 230, 45], 2);
difficultyChoice.insertTitleSegment(0, "Facile", 0);
difficultyChoice.insertTitleSegment(1, "Normale", 0);
difficultyChoice.insertTitleSegment(2, "Difficile", 0);
if(defaultMinutes == 3)
{
  difficultyChoice.selectedSegment = 0;
}
else if(defaultMinutes == 2)
{
  difficultyChoice.selectedSegment = 1;
}
else
{
  difficultyChoice.selectedSegment = 2;
}
difficultyChoice.onMouseUp = function(event)
{
  var minuteLevels = [3, 2, 1];
  var secondLevels = [0, 0, 30];
  defaultMinutes = minuteLevels[difficultyChoice.selectedSegment];
  defaultSeconds = secondLevels[difficultyChoice.selectedSegment];
}
settingsView.addSubview(difficultyChoice);

resetGameText = new UITextLabel([10, 210, 320, 30]);
resetGameText.text = "Altre opzioni:";
resetGameText.setFont( new Font( "Trebuchet MS" , 2 , 18 ) );
settingsView.addSubview(resetGameText);

resetGameButton = new UIImageView(new Image("resetButton.png"));
resetGameButton.position = [window.bounds[2] - resetGameButton.bounds[2], 205];
settingsView.addSubview(resetGameButton);

resetGameButtonText = new UITextLabel([0, 0, resetGameButton.bounds[2], resetGameButton.bounds[3]]);
resetGameButtonText.text = "Nuova partita";
resetGameButtonText.setFont( new Font( "Trebuchet MS" , 2 , 16 ) );
resetGameButtonText.color = [1, 1, 1, 1];
resetGameButtonText.backgroundColor = [0, 0, 0, 0];
resetGameButtonText.centersHorizontally = true;
resetGameButton.addSubview(resetGameButtonText);

resetGameButton.onMouseDown = function(event)
{
  qualify = false;
  killRound("newRound(); leaveSettings();");
}

donate = new UIImageView(new Image("donate.png"));
donate.position = [0, window.bounds[3] - donate.bounds[3]];
settingsView.addSubview(donate);
donate.onMouseDown = function(event)
{
  openURL("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=boy_on_a_stick%40hotmail%2ecom&item_name=digicide%27s%20iPhone%20dev&no_shipping=0&no_note=1&tax=0&currency_code=USD&lc=US&bn=PP%2dDonationsBF&charset=UTF%2d8");
}



timeScoreBack.onMouseDown = portraitTimeScoreBack.onMouseDown = function(event)
{
  round.stop();
  inSettings = true;
  transView.transition(1, settingsView );
}


mainView.addSubview(stage);


minutes = startMinutes;
seconds = startSeconds;
theSeconds = "0" + seconds;
theSeconds = seconds;

score = 0;
scores = [0, 0, 0, 90, 160, 250, 460];
qualify = false;
roundIsOver = false;
donePreparing = true;


round = new Timer(1);
round.onTimer = function(round)
{
  if(decTimer())
  {
    killRound();
  }
  theSeconds = seconds;
  if(seconds < 10)
  { 
    theSeconds = "0" + seconds;
  }
  setTimeScore();
}

letters = [new Object(), new Object(), new Object(), new Object(), new Object(), new Object()];
portraitLetters = [new Object(), new Object(), new Object(), new Object(), new Object(), new Object()];
isLandscape = false;
combinations = [];
foundWords = startFoundWords;
numWordsFound =0;

nullLetter = new Object();
inGrid = [];
onRack = [];
inBoth = [];
availSpots = [];
lastWord = [];
theWord = "";
origOrder = [];


function decTimer()
{
  if(seconds == 0)
  {
    if(minutes == 0)
    {
      return true;
    }
    seconds = 59;
    minutes--;
  }
  else
  {
    seconds--;
  }
  return false;
}

function setTimeScore()
{
  timeScore.text = portraitTimeScore.text = " Tempo: " + minutes + ":" + theSeconds + "\n Pti: " + score;
}

function killRound(doAfterPreparing)
{
  round.stop();
  donePreparing = false;
  var sayWhenDone = "";
  for(var i = 0; i < foundWords.length; i++)
  {
    if(!foundWords[i])
    {
      foundWords[i] = 2;
    }
  }
  text0.text = getTextBox(0);
  text1.text = getTextBox(1);
  text2.text = getTextBox(2);
  text3.text = getTextBox(3);
  text4.text = getTextBox(4);
  text5.text = getTextBox(5);
  text6.text = getTextBox(6);
  text7.text = getTextBox(7);
  text8.text = getTextBox(8);
  text9.text = getTextBox(9);
  text10.text = getTextBox(10);
  text11.text = getTextBox(11);
  text12.text = getTextBox(12);
  portraitText0.text = getTextBox(0, true);
  portraitText1.text = getTextBox(1, true);
  portraitText2.text = getTextBox(2, true);
  portraitText3.text = getTextBox(3, true);
  portraitText4.text = getTextBox(4, true);
  portraitText5.text = getTextBox(5, true);
  
  for(var i = 0; i < inBoth.length; i++)
  {
     inBoth[i].removeFromSuperview();
  }
  pipHolder.removeFromSuperview();
  portraitPipHolder.removeFromSuperview();

  inGrid = [];
  onRack = [];
  inBoth = [];
  availSpots = [];
  combinations = [];
  grid.removeFromSuperview();
  portraitGrid.removeFromSuperview();
  roundOverText.text = portraitRoundOverText.text = "Sto caricando...\nAttendere prego.";
  
  if(numWordsFound == foundWords.length)
  {
    sayWhenDone = "Le hai trovate tutte!  Ecco un bonus!\nTocca 2 volte per continuare.";
    score += numWordsFound * 200;
    setTimeScore();
  }
  else if(qualify)
  {
    sayWhenDone = "Hai superato il livello!\nTocca 2 volte per continuare.";
  }
  else
  {
    if(score > highScore)
    {
      sayWhenDone = "Finito!\nHai superato il record!\nTocca 2 volte per ricominciare.";
      highScoreDisplay.text = "Record: " + score;
      highScore = score;
    }
    else
    {
      sayWhenDone = "Hai perso!\nIl tuo punteggio è " + score + ",  il record " + highScore + ".  Tocca 2 volte per riprovare.";
    }
    score = 0;
  }
  
  roundOver.alpha = portraitRoundOver.alpha = 0;
  stage.addSubview(roundOver);
  portraitView.insertSubviewBelow(portraitRoundOver, portraitBlank);
  var animation = new UIAlphaAnimation(roundOver, 0, 0, 1);
  Animator.addAnimation(animation, 1, true);
  var portraitAnimation = new UIAlphaAnimation(portraitRoundOver, 0, 0, 1);
  Animator.addAnimation(portraitAnimation, 1, true);
  
  var dumbTimer = new Timer(1);
  dumbTimer.onTimer = function(dumbTimer)
  {
    prepareNewRound("", sayWhenDone, doAfterPreparing);
    this.stop();
  }
  dumbTimer.start();
  
  
  roundIsOver = true;
  foundWords = [];
}

dynamic = new Data();
function save(saveCurrent)
{
  var dynamic = new Data();
  if(saveCurrent)
  {
    savedWord = origOrder;
    savedScore = score;
    savedMinutes = minutes;
    savedSeconds = seconds;
    savedFoundWords = foundWords;
  }
  else
  {
    savedWord = "";
    savedScore = 0;
    savedMinutes = defaultMinutes;
    savedSeconds = defaultSeconds;
    savedFoundWords = [];
  }
  dynamic.loadFromString(("highScore = " + highScore + ";\nstartWord = \"" + savedWord + "\";\nstartScore = " + savedScore + ";\nstartMinutes = " + savedMinutes + ";\nstartSeconds = " + savedSeconds + ";"
   + "\n" + "startFoundWords = [" + savedFoundWords + "];\norientation = " + orientation + ";\naccelTwist = " + accelTwist + ";\ndefaultMinutes = " + defaultMinutes + ";\ndefaultSeconds = " + defaultSeconds + ";"));
  dynamic.writeToFile(gameFile);
}


function prepareNewRound(useThisWord, sayWhenDone, doAfterPreparing)
{
  if(useThisWord == null || useThisWord == "")
  {
    theWord = getSixLetterWord();
  }
  else
  {
    theWord = useThisWord;
  }
  origOrder = scrambleWord(theWord);
 
    combinations = getCombinations(theWord);
  
  combinations.sort(sortByLength);
  
  save(score > 0); //if score hasn't been reset, save this new round
  if(sayWhenDone != null && sayWhenDone != "")
  {
    roundOverText.text = portraitRoundOverText.text = sayWhenDone;
  }
  donePreparing = true;
  if(doAfterPreparing != null && doAfterPreparing != "")
  {
    eval(doAfterPreparing);
  }
}

for(var i = 0; i < letters.length; i++)
{
  letters[i].pos = [8 + 75*i, getY(250)];
}

portraitLetterWidth = 48;
//portrait positions
for(var i = 0; i < portraitLetters.length; i++)
{
  portraitLetters[i].pos = [4 + (portraitLetterWidth * 1.1)*i, 400];
}
  

var pipHolder = new UIView([0, getY(260), window.bounds[3], 50]);
var pip0 = new UIImageView(new Image("pip.png"));
pip0.position = [letters[0].pos[0] + 11, 0];
pipHolder.addSubview(pip0);
var pip1 = new UIImageView(new Image("pip.png"));
pip1.position = [letters[1].pos[0] + 11, 0];
pipHolder.addSubview(pip1);
var pip2 = new UIImageView(new Image("pip.png"));
pip2.position = [letters[2].pos[0] + 11, 0];
pipHolder.addSubview(pip2);
var pip3 = new UIImageView(new Image("pip.png"));
pip3.position = [letters[3].pos[0] + 11, 0];
pipHolder.addSubview(pip3);
var pip4 = new UIImageView(new Image("pip.png"));
pip4.position = [letters[4].pos[0] + 11, 0];
pipHolder.addSubview(pip4);
var pip5 = new UIImageView(new Image("pip.png"));
pip5.position = [letters[5].pos[0] + 11, 0];
pipHolder.addSubview(pip5);

var portraitPipHolder = new UIView([6, 405, window.bounds[3], 50]);
pipImage = new Image("pip.png");
pipImage2 = pipImage.createCopy();
pipImage2.resize(30,30);

var portraitPip0 = new UIImageView(pipImage2);
portraitPip0.position = [portraitLetters[0].pos[0] + 5, 0];
portraitPipHolder.addSubview(portraitPip0);
var portraitPip1 = new UIImageView(pipImage2);
portraitPip1.position = [portraitLetters[1].pos[0] + 5, 0];
portraitPipHolder.addSubview(portraitPip1);
var portraitPip2 = new UIImageView(pipImage2);
portraitPip2.position = [portraitLetters[2].pos[0] + 5, 0];
portraitPipHolder.addSubview(portraitPip2);
var portraitPip3 = new UIImageView(pipImage2);
portraitPip3.position = [portraitLetters[3].pos[0] + 5, 0];
portraitPipHolder.addSubview(portraitPip3);
var portraitPip4 = new UIImageView(pipImage2);
portraitPip4.position = [portraitLetters[4].pos[0] + 5, 0];
portraitPipHolder.addSubview(portraitPip4);
var portraitPip5 = new UIImageView(pipImage2);
portraitPip5.position = [portraitLetters[5].pos[0] + 5, 0];
portraitPipHolder.addSubview(portraitPip5);


function getSixLetterWord()
{
  for(var i = Math.floor(Math.random() * dictionary.length); i < dictionary.length; i++)
  {
    if(dictionary[i].length == 6)
    {
      return dictionary[i];
    }
  }
}

function getCombinations(word)
{
  var toReturn = [];
  for(var i = 0; i < dictionary.length; i++)
  {
    var theWord = word;
    for(var j = 0; j < dictionary[i].length; j++)
    {
      var theLetter = dictionary[i].charAt(j);
      var theIndex = theWord.indexOf(theLetter);
      if(theIndex > -1)
      {
        theWord = theWord.replace(theLetter, "");
        if(j == dictionary[i].length - 1)
        {
          toReturn.push(dictionary[i]);
        }
      }      
      else
      {
        break;
      }
    }
  }
  return toReturn;
}



function arrayToString(collection)
{
  theString = "";
  for(var i = 0; i < collection.length; i++)
  {
    theString += collection[i] + "\n";
  }
  return theString;
}

function sortByLength(a, b)
{
  if(a.length < b.length)
  {
    return -1;
  }
  else if(a.length == b.length)
  {
    if(a < b)
    {
      return -1;
    }
    else if(a == b)
    {
      return 0;
    }
    else
    {
      return 1;
    }
  }
  else
  {
    return 1;
  }
}

function scrambleWord(word)
{
  var wordArray = new Array(word.length);
  var swappedString = "";
  for(var i = 0; i < wordArray.length; i++)
  {
    wordArray[i] = word.charAt(i);
  }
  
  for(var i = 0; i < 15; i++)
  {
    var random1 = Math.floor(Math.random() * word.length);
    var random2 = Math.floor(Math.random() * word.length);
    
    var temp = wordArray[random1];
    
    wordArray[random1] = wordArray[random2];
    wordArray[random2] = temp;
  }
  
  for(var i = 0; i < wordArray.length; i++)
  {
    swappedString += wordArray[i];
  }
  return swappedString;
}

function getY(y)
{
  return y - stage.bounds[3];
}

function newRound(theMinutes, theSeconds)
{
  var restoringSave = (theMinutes != null);
  if(theMinutes == null)
  {
    minutes = defaultMinutes;
    seconds = defaultSeconds;
  }
  setTimeScore();
  qualify = false;
  roundIsOver = false;
  numWordsFound = 0;
  roundOver.removeFromSuperview();
  portraitRoundOver.removeFromSuperview();
  stage.addSubview(grid);
  stage.addSubview(pipHolder);
  stage.addSubview(blank);
  
  portraitView.addSubview(portraitPipHolder);
  portraitView.addSubview(portraitGrid);
  portraitView.addSubview(portraitBlank);
  if(restoringSave)
  {
    foundWords = startFoundWords;
      if(!foundWords.length)
      {
        foundWords = new Array(combinations.length);
        for(var i = 0; i < foundWords.length; i++)
        {
          foundWords[i] = 0;
        }
        text0.text = getTextBox(0);
        text1.text = getTextBox(1);
        text2.text = getTextBox(2);
        text3.text = getTextBox(3);
        text4.text = getTextBox(4);
        text5.text = getTextBox(5);
        text6.text = getTextBox(6);
        text7.text = getTextBox(7);
        text8.text = getTextBox(8);
        text9.text = getTextBox(9);
        text10.text = getTextBox(10);
        text11.text = getTextBox(11);
        text12.text = getTextBox(12);
        portraitText0.text = getTextBox(0, true);
        portraitText1.text = getTextBox(1, true);
        portraitText2.text = getTextBox(2, true);
        portraitText3.text = getTextBox(3, true);
        portraitText4.text = getTextBox(4, true);
        portraitText5.text = getTextBox(5, true);
      }
    else
    {
      for(var i = 0; i < foundWords.length; i++)
      {   
        if(foundWords[i])
        {
          numWordsFound++;
          if(combinations[i].length == 6)
          {
            qualify = true;
          }
        }
      }
    }
  }
  else
  {
    foundWords = new Array(combinations.length);
    for(var i = 0; i < foundWords.length; i++)
    {
      foundWords[i] = 0;
    }
  }
  text0.text = getTextBox(0);
  text1.text = getTextBox(1);
  text2.text = getTextBox(2);
  text3.text = getTextBox(3);
  text4.text = getTextBox(4);
  text5.text = getTextBox(5);
  text6.text = getTextBox(6);
  text7.text = getTextBox(7);
  text8.text = getTextBox(8);
  text9.text = getTextBox(9);
  text10.text = getTextBox(10);
  text11.text = getTextBox(11);
  text12.text = getTextBox(12);
  
  portraitText0.text = getTextBox(0, true);
  portraitText1.text = getTextBox(1, true);
  portraitText2.text = getTextBox(2, true);
  portraitText3.text = getTextBox(3, true);
  portraitText4.text = getTextBox(4, true);
  portraitText5.text = getTextBox(5, true);
  
  
  var theWord = combinations[combinations.length - 1]; //always six letters
  
  for(var i = 0; i < theWord.length; i++)
  {
    tempLetterImage = new Image("/letters/" + origOrder.charAt(i) + ".png");
    tempLetterImage2 = tempLetterImage.createCopy();
    tempLetterImage2.resize(portraitLetterWidth, portraitLetterWidth);
    var tempLetter = new UIImageView(new Image("/letters/" + origOrder.charAt(i) + ".png"));
    var portraitTempLetter = new UIImageView(tempLetterImage2);
    stage.addSubview(tempLetter);
    portraitView.addSubview(portraitTempLetter);
    tempLetter.position = letters[i].pos;
    tempLetter.portrait = 0;
    portraitTempLetter.portrait = 1;
    portraitTempLetter.position = portraitLetters[i].pos;
    onRack.push(tempLetter);
    inBoth.push(tempLetter);
    inBoth.push(portraitTempLetter);
    tempLetter.serial = i;
    portraitTempLetter.serial = i;
    tempLetter.place = portraitTempLetter.place = i;
    tempLetter.id = portraitTempLetter.id = origOrder.charAt(i);
    tempLetter.onMouseDown = function(event)
    {
      onRackTap(this, event);
    }
    portraitTempLetter.onMouseDown = function(event)
    {
      onRackTap(this, event);
    }
  }
  round.start();
  return theWord;
}

function onRackTap(target, event)
{
    //flashShockwave(240, getY(160));
    if(target.portrait)
    {
      flashShockwave(portraitLetters[target.place].pos[0] + 27, portraitLetters[0].pos[1] + 20, true);
      
    }
    else
    {
      flashShockwave(letters[target.place].pos[0] + 34, letters[0].pos[1] + 34, false);
    }
    putInGrid(target);
}

function onGridTap(target, event)
{
  if(target == inGrid[inGrid.length - 1]) 
  {
    inGrid.pop();
    availSpots.sort();
    target.place = availSpots.pop();
    
    
    
    
    var theX = letters[target.place].pos[0];
    var theY = letters[target.place].pos[1];
    if(target.portrait)
    {
      theX = portraitLetters[target.place].pos[0];
      theY = portraitLetters[target.place].pos[1];
    }
    var animation = new UIFrameAnimation(target, 1, target.frame, [theX, theY, target.frame[2], target.frame[3]]);
    Animator.addAnimation(animation, .2, true);
    
    if(inGrid.length)
    {
      inGrid[inGrid.length - 1].onMouseDown = function(event)
      {
        onGridTap(this, event);
      }
    }
    target.onMouseDown = function(event)
    {
      onRackTap(this, event);
    }
  }
}

function putInGrid(letter)
{
  availSpots.push(letter.place);
  letter.place = -1;
  inGrid.push(letter);
  letter.onMouseDown = null;
  if(inGrid.length > 1)
  {
    inGrid[inGrid.length - 2].onMouseDown = null;
  }
  var theX = 15 + 73*(inGrid.length - 1);
  var theY = getY(165);
  if(letter.portrait)
  {
      theX = 12 + (portraitLetterWidth*1.035)*(inGrid.length-1);
      theY = 341;
  }
  
  var animation = new UIFrameAnimation(letter, 1, letter.frame, [theX, theY, letter.frame[2], letter.frame[3]]);
  animation.target = letter;
  animation.onStop = function()
  {
    this.target.onMouseDown = function(event)
    {
      onGridTap(this, event, portrait);
    }
  }
  Animator.addAnimation(animation, .2, true);
  
  onRack[letter.place] = nullLetter;
  
  
}

function setTextBoxForIndex(num)
{
  if(num > 104)
  {
    alert("Ehm... è un po' imbarazzante, ma non sono riuscito a creare un insieme di parole così grande.  Sei comunque un vincitore.  Perchè non vai nel menù e scegli una nuova partita...?");
  }
  else
  {
    var theBox = Math.floor(num/8);
    var thePortraitBox = Math.floor(num/17);
    var boxes = [text0, text1, text2, text3, text4, text5, text6, text7, text8, text9, text10, text11, text12];
    var portraitBoxes = [portraitText0, portraitText1, portraitText2, portraitText3, portraitText4, portraitText5];
    boxes[theBox].text = getTextBox(theBox);
    portraitBoxes[thePortraitBox].text = getTextBox(thePortraitBox, true);
  }
}

function getTextBox(num, portrait)
{
  var theString = "";
  var lineCount = 8;
  if(portrait)
  {
    lineCount = 17;
  }
    for(var i = num * lineCount; i < num*lineCount + lineCount && i < foundWords.length; i++)
    {
      if(!foundWords[i])
      {
        theString += combinations[i].replace(/./g,"¤") + "\n";
      }
      else if(foundWords[i] == 1)
      {
        theString += combinations[i] + "\n";
      }
      else if(foundWords[i] == 2)
      {
        theString += combinations[i].toUpperCase() + "\n";
      }
    }
  return theString;
}

portraitView.onTap = portraitTextScroller.onTap = portraitGrid.onTap = portraitRoundOver.onTap = portraitBlank.onTap = roundOver.onTap = textScroller.onTap = back.onTap = blank.onTap = function(tapCount, fingerCount, event)
{
  if(tapCount == 2 && fingerCount == 1)
  {
  
    if(!roundIsOver)
    {
      doubleTapConfirm(tapCount, fingerCount, event);
    }
    else if(donePreparing)
    {
       newRound();
    }
  }
}





function putBack()
{
  if(lastWord.length)
  {
    for(i = 0; i < lastWord.length; i++)
    {
      putInGrid(lastWord[i]);
    }
  }
}


blank.setCanHandleSwipes(true);
blank.onSwipe =

  function( direction , event ) 
  {
    log( "MAIN VIEW SWIPE : " + direction + " : " + event.toSource() );
    if(direction == 8 && !inGrid.length)
    {
      putBack();
    }
  };

twistTimer = new Timer(1);
twistTimer.onTimer = function(twistTimer)
{
  this.stop();
  onAccelerate = function(x,y,z){accelerateFunction(x,y,z);}
}
function twist()
{
  onAccelerate = function(x,y,z)
  {
    if(!inPortrait && y < -.35 && !orientation)
    {
      portrait();
    }
    else if(inPortrait && y > -.05 && !orientation)
    {
      landscape();
    }
    last_x = x;
    last_y = y;
    last_z = z;
  }
  twistTimer.start();
  var swapSpots = [0, 1, 2, 3, 4, 5];
  var onRack2 = onRack.slice();
  
  var affectedSerials = [0, 1, 2, 3, 4, 5];
  for(var i = 0; i < inGrid.length; i++)
  {
    for(var j = 0; j < affectedSerials.length; j++)
    {
      if(affectedSerials[j] == inGrid[i].serial)
      {
        affectedSerials.splice(j, 1);
      }
    }
  }
  // now we have a good list of tiles on the rack, keep going
  
  for(var i = 0; i < affectedSerials.length; i++)
  {
    //pick a spot
    var randIndex = Math.floor(Math.random() * (6-i));
    var newSpot = swapSpots[randIndex];
    //indicate that it's no longer available
    swapSpots.splice(randIndex, 1);
    
    for(var j = 0; j < inBoth.length; j++)
    {
        //find tiles with this serial
        if(inBoth[j].serial == affectedSerials[i])
        {
          inBoth[j].place = newSpot;
          if(inPortrait && inBoth[j].portrait)
          {
            var animation = new UIFrameAnimation(inBoth[j], 1, inBoth[j].frame, [portraitLetters[newSpot].pos[0], portraitLetters[newSpot].pos[1], inBoth[j].frame[2], inBoth[j].frame[3]]);
            Animator.addAnimation(animation, .5, true);
          }
          else if(!inPortrait && !inBoth[j].portrait)
          {
            var animation = new UIFrameAnimation(inBoth[j], 1, inBoth[j].frame, [letters[newSpot].pos[0], letters[newSpot].pos[1], inBoth[j].frame[2], inBoth[j].frame[3]]);
            Animator.addAnimation(animation, .5, true);
          }
        }
    }
  }
  
  //as a bonus, the swapSpots now holds the right values for availSpots
  availSpots = swapSpots.slice();
  
  //done?
}


function doubleTapConfirm(tapCount, fingerCount, event)
{
    if(inGrid.length)
    {
      lastWord = inGrid.slice();
      var theString = "";
      for(var i = 0; i < inGrid.length; i++)
      {
        theString += inGrid[i].id;
      }
    
      var theIndex = search(combinations, theString);
      if(theString.length && theIndex > -1)
      {
        if(!foundWords[theIndex])
        {
          if(theString.length == 6)
          {
            qualify = true;
            if(vibrate)
            {
              Application.vibrateForDuration(1000);
            }
          }
          var graphics = [0, 0, 0, threemessage, fourmessage, fivemessage, qualifymessage];
          flashMessage(graphics[theString.length]);
        
          foundWords[theIndex] = 1;
          numWordsFound++;
          
          setTextBoxForIndex(theIndex);
          score += scores[theString.length];
          if(score > highScore)
          {
            highScoreDisplay.text = "Record: " + score;
          }
          setTimeScore();
          for(var i = inGrid.length - 1; i >= 0; i--)
          {
            onGridTap(inGrid[i], 1, 1, null);
          }
          if(numWordsFound == foundWords.length)
          {
            flashMessage(allmessage);
            killRound();
          }
          else
          {
            flashMessage(graphics[theString.length]);
          }
        }
        else
        {
          flashMessage(againmessage);
          for(var i = inGrid.length - 1; i >= 0; i--)
          {
            onGridTap(inGrid[i], 1, 1, null);
          }
        }
      }
      else if(theString.length)
      {
        flashMessage(nomessage);
        for(var i = inGrid.length - 1; i >= 0; i--)
        {
          onGridTap(inGrid[i], 1, 1, null);
        }
      }
    }
    
    else { twist(); }
  
}
//returns index of item in sorted collection
//or negative value of where item would be
function search(collection, item)
{
  for(var i=0; i < collection.length; i++)
  {
    if(collection[i] == item)
    {
      return i;
    }
  }
  return -1;
}

function flashMessage(graphic)
{
  
  graphic.alpha = .8;
  var endWidth = graphic.origFrame[2]*4;
  var endHeight = graphic.origFrame[3]*4;
  var animation;
  if(inPortrait)
  {
    portraitView.insertSubviewAbove(graphic, portraitGrid);
    graphic.bounds = [window.frame[2]/2, window.frame[3]/2, 0, 0];
    animation = new UIFrameAnimation(graphic, 1, graphic.bounds, [window.frame[2]/2 - endWidth/2, window.frame[3]/2 - endHeight/2, endWidth, endHeight]);
  }
  else
  {
    stage.insertSubviewBelow(graphic, blank);
    graphic.bounds = [window.frame[3]/2, getY(window.frame[2]/2), 0, 0];
    animation = new UIFrameAnimation(graphic, 1, graphic.bounds, [window.frame[3]/2 - endWidth/2, getY(window.frame[2]/2 - endHeight/2), endWidth, endHeight]);
  }
  animation.target = graphic;
  animation.onStop = function()
  {
    this.target.removeFromSuperview();
  }
  var fade = new UIAlphaAnimation(graphic, 1, graphic.alpha, 0);
  Animator.addAnimation(animation, .7, true);
  Animator.addAnimation(fade, .7, true);
}

var shockwaves = [shockwave0, shockwave1, shockwave2, shockwave3, shockwave4, shockwave5];
var usedShockwave = 5;

function flashShockwave(x, y, portrait)
{

  
  var graphic = shockwaves[usedShockwave];
  usedShockwave++;
  if(usedShockwave == 6){usedShockwave = 0;}
  graphic.alpha = 1;
  graphic.bounds = [x - 15, y - 15, 30, 30];
  var endWidth = graphic.origFrame[2]*3;
  var endHeight = graphic.origFrame[3]*3;
  graphic.position = [x, y];
  if(portrait)
  {
    portraitView.insertSubviewAbove(graphic, portraitBack);
  }
  else
  {
    stage.insertSubviewAbove(graphic, back);
  }
  
  var animation = new UIFrameAnimation(graphic, 2, graphic.bounds, [x - endWidth/2, y - endHeight/2, endWidth, endHeight]);
  animation.target = graphic;
  animation.onStop = function()
  {
    this.target.removeFromSuperview();
  }
  var fade = new UIAlphaAnimation(graphic, 2, graphic.alpha, .2);
  Animator.addAnimation(animation, .4, true);
  Animator.addAnimation(fade, .4, true);
}

//Monitor the moves.
var last_x;
var last_y;
var last_z;

function accelerateFunction(x, y, z)
{
  if(!inPortrait && y < -.35 && !orientation)
  {
    portrait();
  }
  else if(inPortrait && y > -.05 && !orientation)
  {
    landscape();
  }
  
  if (accelTwist && (Math.abs(last_x) - Math.abs(x) > 0.2 || Math.abs(last_y) - Math.abs(y) > 0.2) ) 
  {
    twist();
  }

  last_x = x;
  last_y = y;
  last_z = z;
}

onAccelerate = function( x,y,z )
{
  accelerateFunction(x,y,z);
}

onUnload = function()
{
  save(true);
}

function portrait()
{
  inPortrait = true;
  if(!inSettings)
  {
    transView.transition(7, portraitView);
  }
  resetAllLetters(false);
}

function landscape()
{
  inPortrait = false;
  if(!inSettings)
  {
    transView.transition(1, mainView);
  }
  resetAllLetters(true);
}

function resetAllLetters(portraitPlacesAreRight)
{
  inGrid = [];
  for(var i = inBoth.length - 1; i >= 0; i--)
  {
    inBoth[i].onMouseDown = onMouseDown = function(event)
    {
      onRackTap(this, event);
    }
    if(inBoth[i].portrait == portraitPlacesAreRight)
    {
      if(inBoth[i].place == -1)
      {
        //grid letters still don't know where to go.  give them an available spot.
        inBoth[i].place = availSpots.pop();
      }
      for(var j = 0; j < inBoth.length; j++)
      {
        if(inBoth[i].serial == inBoth[j].serial && inBoth[i].portait != inBoth[j].portrait)
        {
          inBoth[j].place = inBoth[i].place;
        }
      }
    }
  }
  // now that they all know where to go, put them there
  for(var i = 0; i < inBoth.length; i++)
  {    
    if(inBoth[i].portrait)
    {
      inBoth[i].position = portraitLetters[inBoth[i].place].pos;
    }
    else
    {
      inBoth[i].position = letters[inBoth[i].place].pos;
    }
  }
}



prepareNewRound(startWord);
score = startScore;
newRound(minutes, seconds);


